import mcculw.ul as mu
import mcculw.enums as me
import Utilities.waveform_creator as wc
import matplotlib.pyplot as plt
import ctypes as ct

board_num, low_chan, high_chan = 0, 0 ,0
ai_range = me.ULRange.BIP10VOLTS

rate=1000
num_points=100

memhandle = mu.scaled_win_buf_alloc(num_points)

ptr = ct.POINTER(ct.c_double)
ctypes_array = ct.cast(memhandle, ptr)

scan_options = me.ScanOptions.SCALEDATA

mu.a_in_scan(board_num, low_chan, high_chan,
             num_points, rate, ai_range, 
             memhandle, scan_options)

num, samp_freq = num_points, rate

t = wc.create_time_data(num, samp_freq)
y = [ctypes_array[i] for i in range(num_points)]

plt.plot(t, y)
plt.show()

mu.win_buf_free(memhandle)

